% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{VarCorr.LmME}
\alias{VarCorr.LmME}
\title{Variances and correlation matrices of random effects of an LmME object}
\usage{
\method{VarCorr}{LmME}(x, sigma = 1, as.lm = FALSE, ...)
}
\arguments{
\item{x}{An LmME object.}

\item{sigma}{Standard deviation of the error term in the LMM parametrization (should
not be set manually, only for consistency with the generic method)}

\item{as.lm}{If TRUE, return the variances and correlations that correspond to
a normal linear mixed model (i.e. \code{lmerMod}).}

\item{...}{Optional arguments (for consistency with generic)}
}
\value{
A list of vectors with variances and correlation matrices corresponding to the
  various grouping variables.
}
\description{
The returned parameters are the transformed versions of the original parameters,
and correspond to the normal linear mixed model parametrization.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
VarCorr(fit) ## tranformation model parametrization
VarCorr(fit, as.lm = TRUE) ## LMM parametrization
}
