% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{model.matrix.tramME}
\alias{model.matrix.tramME}
\title{Model matrix for tramME mdoels}
\usage{
\method{model.matrix}{tramME}(
  object,
  data = model.frame(object),
  type = c("fixef", "ranef"),
  with_baseline = TRUE,
  ...
)
}
\arguments{
\item{object}{A \code{tramME} object.}

\item{data}{A \code{data.frame} containing the variable values.}

\item{type}{Either \code{"fixef"} or \code{"ranef"}.}

\item{with_baseline}{Logical; indicating whether the returned fixed effects model
matrix should contain the columns corresponding to the baseline transfromation.
(ignored when \code{type = "ranef"})}

\item{...}{Additional arguments.}
}
\description{
Creates the model matrix of fixed and random effects corresponding a \code{tramME}
model from a \code{data.frame} of response and covariate values.
}
\note{
The model matrix of the random effects is a sparse matrix and it is transposed
  to be directly used with Matrix::crossprod which is faster than transposing and
  multiplying.
}
