% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terms.R
\name{model.frame.tramME}
\alias{model.frame.tramME}
\title{Extract model frame from a tramME model}
\usage{
\method{model.frame}{tramME}(
  formula,
  data = NULL,
  group_as_factor = FALSE,
  ignore_response = FALSE,
  ...
)
}
\arguments{
\item{formula}{A \code{tramME} object.}

\item{data}{a data.frame, list or environment (or object
    coercible by \code{\link{as.data.frame}} to a data.frame),
    containing the variables in \code{formula}.  Neither a matrix nor an
    array will be accepted.}

\item{group_as_factor}{Logical; If \code{TRUE}, automatically convert the
grouping variables of the random effects to factors. (not used, might not be needed) ## FIXME}

\item{ignore_response}{Logical; If \code{TRUE}, the response is not added to the
result. In this case the function won't look for it in \code{data}.}

\item{...}{Optional arguments, passed to \code{\link[stats]{model.frame}}.}
}
\value{
A \code{tramME_data} object, which is also a \code{data.frame}.
}
\description{
Extract model frame from a tramME model
}
\details{
In \code{\link[mlt]{mlt}}, the basis functions expect the response variables
in the data to be evaluated, i.e. instead of \code{x} and \code{y} columns
we should have a \code{`Surv(x, y)`} column when the response is a
\code{\link[survival]{Surv}} object. \code{model.frame.tramME} builds the
model frame accordingly, assigning to the resulting object the class
\code{tramME_data} to indicate this structure to other functions that use
its results. If the input \code{data} is a \code{tramME_data} is also expects
this structure.
}
\examples{
data("sleepstudy", package = "lme4")
mod <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy, nofit = TRUE)
model.frame(mod)
}
