% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{tramME}
\alias{tramME}
\title{Mixed-effects Additive transformation models}
\usage{
tramME(
  formula,
  data,
  subset,
  weights,
  offset,
  na.action,
  tram = NULL,
  call = NULL,
  ctm = NULL,
  smooth = NULL,
  negative = NULL,
  silent = TRUE,
  resid = FALSE,
  do_update = FALSE,
  estinit = TRUE,
  initpar = NULL,
  fixed = NULL,
  nofit = FALSE,
  control = optim_control(),
  ...
)
}
\arguments{
\item{formula}{A formula describing the model. Smooth additive terms are
defined the way as in \code{mgcv}, and random effects consistently with
the notation used in \code{lme4}.}

\item{data}{an optional data frame, list or environment (or object
          coercible by \code{as.data.frame} to a data frame) containing the
          variables in the model.  If not found in \code{data}, the
          variables are taken from \code{environment(formula)}.
  }

\item{subset}{an optional vector specifying a subset of observations to be
          used in the fitting process.
  }

\item{weights}{an optional vector of case weights to be used in the fitting
          process.  Should be \code{NULL} or a numeric vector. If present,
          the weighted log-likelihood is maximised.
  }

\item{offset}{this can be used to specify an _a priori_ known component to
          be included in the linear predictor during fitting.  This
          should be \code{NULL} or a numeric vector of length equal to the
          number of cases.
  }

\item{na.action}{a function which indicates what should happen when the data
          contain \code{NA}s.  The default is set to \code{na.omit}.
  }

\item{tram}{Parameter vector for the \code{tram} model type.}

\item{call}{The original function call (to be passed from the wrapper).}

\item{ctm}{A model object of the \code{ctm} class that descibes the
fixed-effects part of the \code{tramME} model.}

\item{smooth}{A \code{tramME_smooth} object that describes the smooth
additive elements of the \code{tramME} model.}

\item{negative}{Logical; if \code{TRUE}, the model is parameterized with
negative coefficinets for the elements of the linear predictor.}

\item{silent}{Logical. Make \pkg{TMB} functionality silent.}

\item{resid}{Logical. If \code{TRUE}, the score residuals are also calculated.
This comes with some performance cost.}

\item{do_update}{Logical. If \code{TRUE}, the model is set up so that the weights and the
offsets are updateable. This comes with some performance cost.}

\item{estinit}{Logical. Estimate a vector of initial values for the fixed effects parameters
from a (fixed effects only) mlt model}

\item{initpar}{Named list of initial parameter values, if \code{NULL}, it is ignored}

\item{fixed}{a named vector of fixed regression coefficients; the names
               need to correspond to column names of the design matrix}

\item{nofit}{logical, if TRUE, creates the model object, but does not run the optimization}

\item{control}{list with controls for optimization}

\item{...}{Optional arguments to \code{\link[tram]{tram}}}
}
\description{
A general function to define and fit \code{tramME} models.
}
\details{
The specific model functions (\code{\link[tramME]{LmME}},
\code{\link[tramME]{BoxCoxME}}, \code{\link[tramME]{ColrME}}, etc.) are
wrappers around this function.

For a general description of the transformation model family, see Hothorn et
  al. (2018), for details on the mixed-effects extension, see Tamasi and
  Hothorn (2021).
}
\section{Warning}{


Typically, the \code{tramME} function shouldn't be called directly; it is
  only exported to allow the advanced users to define their \code{tramME}
  models in a more flexible way from their basic building blocks.
}

\references{
Hothorn, Torsten, Lisa Möst, and Peter Bühlmann. "Most Likely
  Transformations."  Scandinavian Journal of Statistics 45, no. 1 (March
  2018): 110–34.  <doi:10.1111/sjos.12291>

Tamasi, Balint, and Torsten Hothorn. "tramME: Mixed-Effects Transformation
  Models Using Template Model Builder." The R Journal 13, no. 2 (2021):
  398–418. <doi:10.32614/RJ-2021-075>
}
