% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr.R
\name{cockcroft}
\alias{cockcroft}
\title{Creatinine clearance by Cockcroft-Gault equation}
\usage{
cockcroft(creat, age, sex, weight, units = "SI")
}
\arguments{
\item{creat}{numeric vector of creatinine levels in µmol/l (or mg/dl if units = "US")}

\item{age}{numeric vector of ages in years}

\item{sex}{character vector of sex ("F" = female, "M" = male)}

\item{weight}{numeric vector of weights in kilograms}

\item{units}{non-vectorised parameter for creatinine units ("SI" for µmol/l (default) or "US" for mg/dl)}
}
\value{
numeric vector of creatinine clearances in ml/min
}
\description{
A vectorised function to estimate creatinine clearance using the Cockcroft-Gault equation.
By default this uses serum creatinine in µmol/l but can be changed to mg/dl by setting the
units parameter to "US"
}
\details{
Reference: Cockcroft DW, Gault MH. Prediction of creatinine clearance from serum creatinine.
Nephron 1976; 16(1):31-41
}
\examples{
# calculate creatinine clearance using creatinine in µmol/l
cockcroft(creat = 88.4, age = 25, sex = "F", weight = 60)

# calculate using creatinine in mg/dl
cockcroft(creat = 1, age = 25, sex = "F", weight = 60, units = "US")
}
