% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_intersection.R
\name{get_intersection}
\alias{get_intersection}
\title{Get Intersection Point of Two Lines}
\usage{
get_intersection(x, y)
}
\arguments{
\item{x}{A named vector with intercept ["a"] and slope ["b"].}

\item{y}{A named vector with intercept ["a"] and slope ["b"].}
}
\value{
A named vector giving the intersection, \code{\link{NULL}} if the
lines do not intersect,  \code{\link{NaN}} if they are identical.
}
\description{
Get the intersection point of two straight lines given in slope–intercept
form.
}
\examples{
get_intersection(x = c(a = 0, b = 1), y = c(a = 2, b = -1))
get_intersection(x = c(a = 0, b = 1), y = c(a = 2, b = 1))
x <- c(a = 0, b = 1)
get_intersection(x = x, y = x)
}
\seealso{
Other geometry functions: 
\code{\link{points2equation}()},
\code{\link{vector_length}()}
}
\concept{geometry functions}
\keyword{internal}
