% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_node_heights.R
\name{calculate_expected_leaves_sptree}
\alias{calculate_expected_leaves_sptree}
\alias{ave_tips_st}
\title{Calculate expected leaves of a species tree}
\usage{
calculate_expected_leaves_sptree(lambda, mu, t)

ave_tips_st(lambda, mu, t)
}
\arguments{
\item{lambda}{speciation rate}

\item{mu}{extinction rate}

\item{t}{time to simulate until}
}
\value{
The expected number of leaves
}
\description{
Calculate expected leaves of a species tree
}
\details{
Calculates the expected number of leaves for a birth-death
   simulation given a speciation and extinction rate and a time.
}
\examples{
spec_rate <- 1.0
ext_rate <- 0.5
time <- 2
ave_tips_st(spec_rate, ext_rate, time)
}
\references{
Mooers, A., Gascuel, O., Stadler, T., Li, H., & Steel, M. (2012).
    Branch lengths on birth–death trees and the expected loss of phylogenetic
     diversity. Systematic biology, 61(2), 195-203.
}
