% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-methods.R
\name{calcNdBlnc}
\alias{calcNdBlnc}
\title{Calculate the balance of a node}
\usage{
calcNdBlnc(tree, nid)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{nid}{node id}
}
\description{
Returns the balance of a node.
}
\details{
Balance is calculated as the absolute difference between the number of descendents 
of the two bifurcating edges of a node and the expected value for a balanced tree.
\code{NA} is returned if the node is polytomous or a tip.
}
\examples{
library(treeman)
tree <- randTree(10)
calcNdBlnc(tree, nid=tree['root'])  # root balance
}
\seealso{
\code{\link{calcNdsBlnc}}, 
\url{https://github.com/DomBennett/treeman/wiki/calc-methods}
}

