% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-methods.R
\name{calcNdsBlnc}
\alias{calcNdsBlnc}
\title{Calculate the balances of all nodes}
\usage{
calcNdsBlnc(tree, nids, ...)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{nids}{node ids}

\item{...}{\code{plyr} arguments}
}
\description{
Returns the absolute differences in number of descendants for bifurcating 
branches of every node
}
\details{
Runs \code{calcNdBlnc()} across all node IDs. \code{NA} is returned if the
node is polytomous. Parallelizable.
}
\examples{
library(treeman)
tree <- randTree(10)
calcNdsBlnc(tree, nids=tree['nds'])
}
\seealso{
\code{\link{calcNdBlnc}}, 
\url{https://github.com/DomBennett/treeman/wiki/calc-methods}
}

