% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-methods.R
\name{setNdsSpn}
\alias{setNdsSpn}
\title{Set the branch lengths of specific nodes}
\usage{
setNdsSpn(tree, ids, vals, ...)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{ids of nodes whose preceding edges are to be changed}

\item{vals}{new spans}

\item{...}{\code{plyr} arguments}
}
\description{
Return a tree with the span of a node altered.
}
\details{
Runs \code{setNdSpn} over multiple nodes. Parallelizable.
}
\examples{
library(treeman)
tree <- randTree(10)
# make tree taxonomic
tree <- setNdsSpn(tree, ids=tree['all'], vals=1)
}
\seealso{
\code{\link{setNdSpn}}
\url{https://github.com/DomBennett/treeman/wiki/set-methods}
}

