% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip-methods.R
\name{rmNodes}
\alias{rmNodes}
\title{Remove nodes from a tree}
\usage{
rmNodes(tree, nids, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{nids}{internal node IDs}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Returns a tree with a node ID(s) removed
}
\details{
Removes nodes in a tree. Joins the nodes following to
the nodes preceding the node to be removed. Creates polytomies.
Warning: do not use this function to remove tip nodes, this create a
corrupted tree.
}
\examples{
library(treeman)
tree <- randTree(10)
tree <- rmNodes(tree, 'n3')
summary(tree)  # tree is now polytmous
}
\seealso{
\code{\link{addTip}}, \code{\link{rmTips}},
 \url{https://github.com/DomBennett/treeman/wiki/manip-methods}
}
