% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node_text}
\alias{node_text}
\title{Get a node's underlying text}
\usage{
node_text(x)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}
}
\value{
A single string containing the node's text.
}
\description{
\code{node_text()} returns the document text underlying a node.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "1 + foo"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

node |>
  node_child(1) |>
  node_child_by_field_name("rhs") |>
  node_text()
\dontshow{\}) # examplesIf}
}
