% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{tree_root_node}
\alias{tree_root_node}
\title{Retrieve the root node of the tree}
\usage{
tree_root_node(x)
}
\arguments{
\item{x}{\verb{[tree_sitter_tree]}

A tree.}
}
\value{
A node.
}
\description{
\code{tree_root_node()} is the entry point for accessing nodes within
a specific tree. It returns the "root" of the tree, from which you
can use other \verb{node_*()} functions to navigate around.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

# Trees and nodes have a similar print method, but you can
# only use other `node_*()` functions on nodes.
tree
node

node |>
  node_child(1) |>
  node_children()
\dontshow{\}) # examplesIf}
}
