% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipe.R
\name{make_pipe}
\alias{make_pipe}
\alias{\%@>\%}
\alias{\%<@>\%}
\alias{\%try>\%}
\title{Create a pipe operator.}
\usage{
make_pipe(propagate, keep_also = NULL, try = FALSE)

lhs \%@>\% rhs

lhs \%<@>\% rhs

lhs \%try>\% rhs
}
\arguments{
\item{propagate}{character. See the eponymous argument in \code{\link[tribe]{shield}}.}

\item{keep_also}{character. See the eponymous argument in \code{\link[tribe]{shield}}.}

\item{try}{logical. If \code{TRUE} and the pipe \code{x > f} generates an error, 
then the pipe \code{x try> f} returns \code{x} unchanged silently.}

\item{lhs}{Left-hand side of the pipe.}

\item{rhs}{Right-hand side of the pipe.}
}
\description{
This function is used to create magrittr like pipe operators.
}
\examples{
library(dplyr)
df <- data.frame(x = sample(10, 5, rep = TRUE),
                 y = sample(10, 5, rep = TRUE)) \%>\%
  define(example="yes",
         package="dplyr", 
         class = c("my_tbl", "data.frame"))
tribe(df)

# Attributes just created are lost when the object 
# passes through dplyr verbs
tribe(df \%>\% mutate(z=3))

# With the pipe '\%@>\%', most attributes are kept
tribe(df \%@>\% mutate(z=3))

# One can create a new pipe to adjust attributes propagation settings
"\%newpipe>\%" <- make_pipe(propagate="none", keep_also = "example")
tribe(df \%newpipe>\% mutate(z=3))

}
\seealso{
\code{\link{shield}} in this package.
}
\author{
Stefan Milton Bache and Hadley Wickham for the 
original \code{pipe} function in package \pkg{magrittr}; 
Paul Poncet for the modifications introduced.
}
