% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethod.R
\name{trip-accessors}
\alias{getTORnames}
\alias{getTimeID}
\alias{print.summary.TORdata}
\alias{trip-accessors}
\title{Functions to retrieve DateTime and ID data from within (Spatial) data
frames.}
\usage{
getTORnames(obj)

getTimeID(obj)

\method{print}{summary.TORdata}(x, ...)
}
\arguments{
\item{obj}{\code{trip} object.}

\item{x}{trip object}

\item{\dots}{currently ignored}
}
\value{
\code{getTORnames} retrieves the column names from an object extending the
class \code{TimeOrderedRecords}, and \code{getTimeID} returns the data as a
data frame from an object extending the class \code{TimeOrderedRecords}.
}
\description{
Functions for retrieving the names of the columns used for DateTime and ID,
as well as the data.
}
\examples{


tor <- TimeOrderedRecords(c("time", "id"))
getTORnames(tor)

}
\seealso{
\code{\link{trip-class}}, for the use of this class with
\code{\link[sp]{SpatialPointsDataFrame}}.

\code{\link{trip}}
}
\keyword{manip}

