% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipcw.R
\name{ipcw}
\alias{ipcw}
\title{Inverse Probability of Censoring Weights (IPCW) for Treatment
Switching}
\usage{
ipcw(
  data,
  id = "id",
  stratum = "",
  tstart = "tstart",
  tstop = "tstop",
  event = "event",
  treat = "treat",
  swtrt = "swtrt",
  swtrt_time = "swtrt_time",
  base_cov = "",
  numerator = "",
  denominator = "",
  logistic_switching_model = FALSE,
  strata_main_effect_only = TRUE,
  ns_df = 3,
  firth = FALSE,
  flic = FALSE,
  stabilized_weights = TRUE,
  trunc = 0,
  trunc_upper_only = TRUE,
  swtrt_control_only = TRUE,
  alpha = 0.05,
  ties = "efron",
  boot = FALSE,
  n_boot = 1000,
  seed = NA
)
}
\arguments{
\item{data}{The input data frame that contains the following variables:
\itemize{
\item \code{id}: The id to identify observations belonging to the same
subject for counting process data with time-dependent covariates.
\item \code{stratum}: The stratum.
\item \code{tstart}: The starting time of the time interval for
counting-process data with time-dependent covariates.
\item \code{tstop}: The stopping time of the time interval for
counting-process data with time-dependent covariates.
\item \code{event}: The event indicator, 1=event, 0=no event.
\item \code{treat}: The randomized treatment indicator, 1=treatment,
0=control.
\item \code{swtrt}: The treatment switch indicator, 1=switch, 0=no switch.
\item \code{swtrt_time}: The time from randomization to treatment switch.
\item \code{base_cov}: The baseline covariates (excluding treat) used in
the outcome model.
\item \code{numerator}: The baseline covariates (excluding treat) used in
the numerator switching model for stabilized weights.
\item \code{denominator}: The baseline (excluding treat) and time-dependent
covariates used in the denominator switching model.
}}

\item{id}{The name of the id variable in the input data.}

\item{stratum}{The name(s) of the stratum variable(s) in the input data.}

\item{tstart}{The name of the tstart variable in the input data.}

\item{tstop}{The name of the tstop variable in the input data.}

\item{event}{The name of the event variable in the input data.}

\item{treat}{The name of the treatment variable in the input data.}

\item{swtrt}{The name of the swtrt variable in the input data.}

\item{swtrt_time}{The name of the swtrt_time variable in the input data.}

\item{base_cov}{The names of baseline covariates (excluding
treat) in the input data for the Cox model.}

\item{numerator}{The names of baseline covariates
(excluding treat) in the input data for the numerator switching
model for stabilized weights.}

\item{denominator}{The names of baseline  (excluding treat) and
time-dependent covariates in the input data for the denominator
switching model.}

\item{logistic_switching_model}{Whether a pooled logistic regression
switching model is used.}

\item{strata_main_effect_only}{Whether to only include the strata main
effects in the logistic regression switching model. Defaults to
\code{TRUE}, otherwise all possible strata combinations will be
considered in the switching model.}

\item{ns_df}{Degrees of freedom for the natural cubic spline for
visit-specific intercepts of the pooled logistic regression model.
Defaults to 3 for two internal knots at the 33 and 67 percentiles
of the treatment switching times.}

\item{firth}{Whether the Firth's bias reducing penalized likelihood
should be used.}

\item{flic}{Whether to apply intercept correction to obtain more
accurate predicted probabilities.}

\item{stabilized_weights}{Whether to use the stabilized weights.
The default is \code{TRUE}.}

\item{trunc}{The truncation fraction of the weight distribution.
Defaults to 0 for no truncation in weights.}

\item{trunc_upper_only}{Whether to truncate the weights from the upper
end of the weight distribution only. Defaults to \code{TRUE}, otherwise
the weights will be truncated from both the lower and upper ends of
the distribution.}

\item{swtrt_control_only}{Whether treatment switching occurred only in
the control group. The default is \code{TRUE}.}

\item{alpha}{The significance level to calculate confidence intervals.}

\item{ties}{The method for handling ties in the Cox model, either
"breslow" or "efron" (default).}

\item{boot}{Whether to use bootstrap to obtain the confidence
interval for hazard ratio. Defaults to \code{FALSE}.}

\item{n_boot}{The number of bootstrap samples.}

\item{seed}{The seed to reproduce the bootstrap results. The default is
\code{NA}, in which case, the seed from the environment will be used.}
}
\value{
A list with the following components:
\itemize{
\item \code{logrank_pvalue}:  The two-sided p-value of the log-rank test
for the ITT analysis.
\item \code{cox_pvalue}: The two-sided p-value for treatment effect based on
the weighted Cox model excluding data after treatment switch.
If \code{boot} is \code{TRUE}, this value represents the
bootstrap p-value.
\item \code{hr}: The estimated hazard ratio from the Cox model.
\item \code{hr_CI}: The confidence interval for hazard ratio.
\item \code{hr_CI_type}: The type of confidence interval for hazard ratio,
either "Cox model" or "bootstrap".
\item \code{data_switch}: A list of input data for the switching models by
treatment group. The variables include \code{id}, \code{stratum},
\code{"tstart"}, \code{"tstop"}, \code{"cross"}, \code{denominator},
\code{swtrt}, and \code{swtrt_time}. For logistic switching models,
\code{stratum} variables are converted to dummy variables, and
natural cubic spline basis variables are created for the visit-specific
intercepts.
\item \code{fit_switch}: A list of fitted switching models for the
denominator and numerator by treatment group.
\item \code{data_outcome}: The input data for the outcome Cox model
including the inverse probability of censoring weights.
The variables include \code{id}, \code{stratum}, \code{"tstart"},
\code{"tstop"}, \code{"event"}, \code{"treated"},
\code{"unstablized_weight"}, \code{"stabilized_weight"},
\code{base_cov}, and \code{treat}.
\item \code{km_outcome}: The Kaplan-Meier estimates of the survival
functions for the treatment and control groups based on the
weighted outcome data.
\item \code{lr_outcome}: The log-rank test results for the treatment
effect based on the weighted outcome data.
\item \code{fit_outcome}: The fitted outcome Cox model.
\item \code{fail}: Whether a model fails to converge.
\item \code{settings}: A list with the following components:
\itemize{
\item \code{logistic_switching_model}: Whether a pooled logistic
regression switching model is used.
\item \code{strata_main_effect_only}: Whether to only include the strata
main effects in the logistic regression switching model.
\item \code{ns_df}: Degrees of freedom for the natural cubic spline.
\item \code{firth}: Whether the Firth's penalized likelihood is used.
\item \code{flic}: Whether to apply intercept correction.
\item \code{stabilized_weights}: Whether to use the stabilized weights.
\item \code{trunc}: The truncation fraction of the weight distribution.
\item \code{trunc_upper_only}: Whether to truncate the weights from the
upper end of the distribution only.
\item \code{swtrt_control_only} Whether treatment switching occurred
only in the control group.
\item \code{alpha}: The significance level to calculate confidence
intervals.
\item \code{ties}: The method for handling ties in the Cox model.
\item \code{boot}: Whether to use bootstrap to obtain the confidence
interval for hazard ratio.
\item \code{n_boot}: The number of bootstrap samples.
\item \code{seed}: The seed to reproduce the bootstrap results.
}
\item \code{fail_boots}: The indicators for failed bootstrap samples
if \code{boot} is \code{TRUE}.
\item \code{fail_boots_data}: The data for failed bootstrap samples
if \code{boot} is \code{TRUE}.
\item \code{hr_boots}: The bootstrap hazard ratio estimates
if \code{boot} is \code{TRUE}.
}
}
\description{
Excludes data after treatment switching and fits a switching
model to estimate the probability of not switching. The inverse of
these probabilities (inverse probability of censoring weights) are then
used as weights in a weighted Cox model to obtain the adjusted hazard
ratio.
}
\details{
The hazard ratio and confidence interval under a no-switching
scenario are obtained as follows:
\itemize{
\item Exclude all observations after treatment switch.
\item Define the crossover and event indicators for the last time interval
of each subject.
\item For time-dependent Cox switching models, replicate unique event times
across treatment arms within each subject.
\item Fit the denominator switching model (and numerator model for
stabilized weights) to estimate inverse probability of censoring
weights. Either a Cox model with time-dependent covariates or
a pooled logistic regression model can be used.
\itemize{
\item For the pooled logistic regression model, the probability of
remaining uncensored (i.e., not switching) is calculated as
\eqn{1 - \hat{p}_{\text{switch}}}
and accumulated over time up to the start of each interval.
\item For the time-dependent Cox model, the probability of remaining
unswitched is derived from the estimated baseline hazard and
predicted risk score up to the end of each interval.
}
\item Fit a weighted Cox model to the outcome survival times (excluding
data after switching) to estimate the hazard ratio.
\item Construct the p-value and confidence interval for the hazard ratio
using either robust sandwich variance or bootstrapping. When
bootstrapping is used, the confidence interval and p-value are
based on a t-distribution with \code{n_boot - 1} degrees of freedom.
}
}
\examples{

# Example 1: pooled logistic regression switching model
library(dplyr)

sim1 <- tssim(
  tdxo = 1, coxo = 1, allocation1 = 1, allocation2 = 1,
  p_X_1 = 0.3, p_X_0 = 0.3, 
  rate_T = 0.002, beta1 = -0.5, beta2 = 0.3, 
  gamma0 = 0.3, gamma1 = -0.9, gamma2 = 0.7, gamma3 = 1.1, gamma4 = -0.8,
  zeta0 = -3.5, zeta1 = 0.5, zeta2 = 0.2, zeta3 = -0.4, 
  alpha0 = 0.5, alpha1 = 0.5, alpha2 = 0.4, 
  theta1_1 = -0.4, theta1_0 = -0.4, theta2 = 0.2,
  rate_C = 0.0000855, accrualIntensity = 20/30,
  fixedFollowup = FALSE, plannedTime = 1350, days = 30,
  n = 500, NSim = 100, seed = 314159)
  
fit1 <- ipcw(
  sim1[[1]], id = "id", tstart = "tstart", 
  tstop = "tstop", event = "event", treat = "trtrand", 
  swtrt = "xo", swtrt_time = "xotime", 
  base_cov = "bprog", numerator = "bprog", 
  denominator = c("bprog", "L"),
  logistic_switching_model = TRUE, ns_df = 3,
  swtrt_control_only = TRUE, boot = FALSE)
  
c(fit1$hr, fit1$hr_CI) 

# Example 2: time-dependent covariates Cox switching model

fit2 <- ipcw(
  shilong, id = "id", tstart = "tstart", tstop = "tstop", 
  event = "event", treat = "bras.f", swtrt = "co", 
  swtrt_time = "dco", 
  base_cov = c("agerand", "sex.f", "tt_Lnum", "rmh_alea.c", 
               "pathway.f"),
  numerator = c("agerand", "sex.f", "tt_Lnum", "rmh_alea.c", 
                "pathway.f"),
  denominator = c("agerand", "sex.f", "tt_Lnum", "rmh_alea.c",
                  "pathway.f", "ps", "ttc", "tran"),
  swtrt_control_only = FALSE, boot = FALSE)

c(fit2$hr, fit2$hr_CI)

}
\references{
James M. Robins and Dianne M. Finkelstein.
Correcting for noncompliance and dependent censoring in an AIDS clinical
trial with inverse probability of censoring weighted (IPCW) log-rank tests.
Biometrics. 2000;56(3):779-788.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
