###################################################
### chunk number 1: 
###################################################
require(tsDyn)
require(tseriesChaos)
options(prompt=" ", encoding="LATIN-9")


###################################################
### chunk number 2:  eval=FALSE
###################################################
## autopairs(x, lag=, type=, h=)


###################################################
### chunk number 3: 
###################################################
obj <- llar(log(lynx), m=3)
plot(obj)


###################################################
### chunk number 4: 
###################################################
obj <- data.frame(obj)


###################################################
### chunk number 5: 
###################################################
names(obj)


###################################################
### chunk number 6: 
###################################################
plot(RMSE~eps, data=obj, type="l", log="x")


###################################################
### chunk number 7:  eval=FALSE
###################################################
## delta.test(x)


###################################################
### chunk number 8: 
###################################################
availableModels()


###################################################
### chunk number 9:  eval=FALSE
###################################################
## x.new <- predict(obj, n.ahead = )


###################################################
### chunk number 10:  eval=FALSE
###################################################
## obj <- setar(x, m=, d=, steps=, thDelay= )


###################################################
### chunk number 11:  eval=FALSE
###################################################
## obj <- setar(x, m=, d=, steps=, mTh= )


###################################################
### chunk number 12:  eval=FALSE
###################################################
## obj <- setar(x, m=, d=, steps=, thVar= )


###################################################
### chunk number 13:  eval=FALSE
###################################################
## obj <- setar(x, m=, d=, steps=, thDelay = , mL =, mH =)


###################################################
### chunk number 14:  eval=FALSE
###################################################
## obj <- nnetTs(x, m=, d=, steps=, size=)


###################################################
### chunk number 15:  eval=FALSE
###################################################
## obj <- aar(x, m=, d=, steps=)


###################################################
### chunk number 16: 
###################################################
x <- log10(lynx)
selectSETAR(x, m=3, mL=1:3, mH=1:3, thSteps = 5, thDelay=0:2)


###################################################
### chunk number 17: 
###################################################
str(lynx)
summary(lynx)
plot(lynx)


###################################################
### chunk number 18: 
###################################################
x <- log10(lynx)


###################################################
### chunk number 19: 
###################################################
par(mfrow=c(2,1), mar=c(0,0,0,0))
plot(x, ax=F)
box()
plot(x[length(x):1], type="l", ax=F)
box()


###################################################
### chunk number 20: 
###################################################
par(mfrow=c(2,1), mar=c(2,2,0,0))
autopairs(x, lag=1, type="regression", GUI=FALSE)
autopairs(x, lag=3, type="regression", GUI=FALSE)


###################################################
### chunk number 21: 
###################################################
hist(x, br=13)


###################################################
### chunk number 22: 
###################################################
par(mfrow=c(2,1), mar=c(2,4,0,0))
acf(x)
pacf(x)


###################################################
### chunk number 23: 
###################################################
library(tseriesChaos)
mutual(x)


###################################################
### chunk number 24: 
###################################################
recurr(x, m=3, d=1, levels=c(0,0.2,1))


###################################################
### chunk number 25: 
###################################################
lag.plot(x, lags=3, layout=c(1,3))


###################################################
### chunk number 26: 
###################################################
delta.test(x)
delta.lin.test(x)


###################################################
### chunk number 27: 
###################################################
mod.ar <- linear(x, m=2)
mod.ar


###################################################
### chunk number 28: 
###################################################
mod.setar <- setar(x, m=2, mL=2, mH=2, thDelay=1)
mod.setar


###################################################
### chunk number 29: 
###################################################
beta <- round(coef(mod.setar),3)


###################################################
### chunk number 30: 
###################################################
set.seed(10)


###################################################
### chunk number 31: 
###################################################
mod <- list()
mod[["linear"]] <- linear(x, m=2)
mod[["setar"]] <- setar(x, m=2, thDelay=1)
mod[["lstar"]] <- lstar(x, m=2, thDelay=1)
mod[["nnetTs"]] <- nnetTs(x, m=2, size=3)
mod[["aar"]] <- aar(x, m=2)


###################################################
### chunk number 32: 
###################################################
sapply(mod, AIC)
sapply(mod, MAPE)


###################################################
### chunk number 33: 
###################################################
summary(mod[["setar"]])


###################################################
### chunk number 34:  eval=FALSE
###################################################
## plot(mod[["setar"]])


###################################################
### chunk number 35: 
###################################################
set.seed(10)
mod.test <- list()
x.train <- window(x, end=1924)
x.test <- window(x, start=1925)
mod.test[["linear"]] <- linear(x.train, m=2)
mod.test[["setar"]] <- setar(x.train, m=2, thDelay=1)
mod.test[["lstar"]] <- lstar(x.train, m=2, thDelay=1, trace=FALSE, control=list(maxit=1e5))
mod.test[["nnet"]] <- nnetTs(x.train, m=2, size=3, control=list(maxit=1e5))
mod.test[["aar"]] <- aar(x.train, m=2)


###################################################
### chunk number 36: 
###################################################
frc.test <- lapply(mod.test, predict, n.ahead=10)
plot(x.test,ylim=range(x))
for(i in 1:length(frc.test))
	lines(frc.test[[i]], lty=i+1, col=i+1)

legend(1925,2.4, lty=1:(length(frc.test)+1), col=1:(length(frc.test)+1), legend=c("observed",names(frc.test)))


###################################################
### chunk number 37: 
###################################################
par(cex=0.6)


###################################################
### chunk number 38: 
###################################################
x.new <- predict(mod[["linear"]], n.ahead=100)
lag.plot(x.new, 1)


###################################################
### chunk number 39: 
###################################################
x.new <- predict(mod[["setar"]], n.ahead=100)
lag.plot(x.new, 1)


###################################################
### chunk number 40: 
###################################################
x.new <- predict(mod[["nnetTs"]], n.ahead=100)
lag.plot(x.new, 1)


###################################################
### chunk number 41: 
###################################################
mod.point <- setar(x, m=10, mL=3, mH=10, thDelay=0, th=3.12)
lag.plot(predict(mod.point, n.ahead=100))


###################################################
### chunk number 42: 
###################################################
mod.unstable <- setar(x, m=9, mL=9, mH=6, thDelay=4, th=2.61)
lag.plot(predict(mod.unstable, n.ahead=100))


###################################################
### chunk number 43: 
###################################################
mod.chaos1 <- setar(x, m=5, mL=5, mH=3, thDelay=1, th=2.78)
lag.plot(predict(mod.chaos1, n.ahead=100))


###################################################
### chunk number 44: 
###################################################
mod.chaos2 <- setar(x, m=5, mL=5, mH=3, thDelay=1, th=2.95)
lag.plot(predict(mod.chaos2, n.ahead=100))


###################################################
### chunk number 45: 
###################################################
N <- 1000
x.new <- predict(mod[["setar"]], n.ahead=N)
x.new <- x.new + rnorm(N, sd=sd(x.new)/100)
ly <- lyap_k(x.new, m=2, d=1, t=1, k=2, ref=750, s=200, eps=sd(x.new)/10)
plot(ly)


###################################################
### chunk number 46: 
###################################################
x.new <- predict(mod.chaos2, n.ahead=N)
x.new <- x.new + rnorm(N, sd=sd(x.new)/100)
ly <- lyap_k(x.new, m=5, d=1, t=1, k=2, ref=750, s=200, eps=sd(x.new)/10)
plot(ly)


###################################################
### chunk number 47: 
###################################################
lyap(ly,start=6,end=70)


