% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval.R
\name{pull_interval}
\alias{pull_interval}
\alias{time_unit}
\title{Extract time interval from a vector}
\usage{
pull_interval(x)

time_unit(x)
}
\arguments{
\item{x}{A vector of \code{POSIXt}, \code{Date}, \code{yearmonth}, \code{yearquarter}, \code{difftime},
\code{hms}, \code{integer}, \code{numeric}.}
}
\value{
\code{pull_interval()}: an "interval" class (a list) includes "year",
"quarter", "month", #' "week", "day", "hour", "minute", "second", "unit", and
other self-defined interval.
}
\description{
Assuming regularly spaced time, the \code{pull_interval()} returns a list of time
components as the "interval" class; the \code{time_unit()} returns the value of
time units.
}
\details{
The \code{pull_interval()} and \code{time_unit()} make a tsibble extensible to
support custom time index.
}
\examples{
x <- seq(as.Date("2017-10-01"), as.Date("2017-10-31"), by = 3)
pull_interval(x)
# at two months interval ----
x <- yearmonth(seq(2016, 2018, by = 0.5))
time_unit(x)
}
