% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find-chains.R
\name{find_chains}
\alias{find_chains}
\title{Find Time Series Chains}
\usage{
find_chains(.mp)
}
\arguments{
\item{.mp}{a TSMP object of class \code{MatrixProfile}.}
}
\value{
Returns the input \code{.mp} object with a new name \code{chain}. It contains: \code{chains}, a \code{list}
of chains founded with more than 2 patterns and \code{best} with the best one.
}
\description{
Time Series Chains is a new primitive for time series data mining.
}
\examples{
w <- 50
data <- mp_gait_data
mp <- tsmp(data, window_size = w, exclusion_zone = 1 / 4, verbose = 0)
mp <- find_chains(mp)
}
\references{
\itemize{
\item Zhu Y, Imamura M, Nikovski D, Keogh E. Matrix Profile VII: Time Series Chains: A
New Primitive for Time Series Data Mining. Knowl Inf Syst. 2018 Jun 2;1–27.
}

Website: \url{https://sites.google.com/site/timeserieschain/}
}
