% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_qes.R
\name{ts_fil_qes}
\alias{ts_fil_qes}
\title{Quadratic Exponential Smoothing}
\usage{
ts_fil_qes(gamma = FALSE)
}
\arguments{
\item{gamma}{If TRUE, enables the gamma seasonality component.}
}
\value{
a \code{ts_fil_qes} obj.
}
\description{
This code implements quadratic exponential smoothing on a time series.
Quadratic exponential smoothing is a smoothing technique that includes components of
both trend and seasonality in time series forecasting.
}
\examples{
# time series with noise
library(daltoolbox)
data(sin_data)
sin_data$y[9] <- 2*sin_data$y[9]

# filter
filter <- ts_fil_qes()
filter <- fit(filter, sin_data$y)
y <- transform(filter, sin_data$y)

# plot
plot_ts_pred(y=sin_data$y, yadj=y)
}
