% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_tvReg.R, R/kernels.R, R/plot_tvReg.R,
%   R/tvCov.R, R/tvFE.R, R/tvIRF.R, R/tvOLS.R, R/tvRE.R, R/utils.R
\name{.tvLM.ci}
\alias{.tvLM.ci}
\alias{.tvSURE.ci}
\alias{tvReg-internals}
\alias{.kernel}
\alias{.univariatePlot}
\alias{.tvCov.cv}
\alias{.tvFE.cv}
\alias{.tvIRF}
\alias{.tvOLS.cv}
\alias{.tvRE.cv}
\alias{tvreg.control}
\title{tvReg internal and secondary functions}
\usage{
.tvLM.ci(x, yboot)

.tvSURE.ci(x, yboot)

.kernel(x, bw, tkernel = "Triweight")

.univariatePlot(x, vars = NULL, ylim = NULL, ...)

.tvCov.cv(
  bw,
  x,
  z = NULL,
  cv.block = 0,
  est = c("lc", "ll"),
  tkernel = c("Triweight", "Epa", "Gaussian")
)

.tvFE.cv(
  bw,
  x,
  y,
  z = NULL,
  neq,
  obs,
  cv.block = 0,
  est = c("lc", "ll"),
  tkernel = c("Triweight", "Epa", "Gaussian")
)

.tvIRF(
  x,
  impulse,
  response,
  y.names,
  n.ahead,
  ortho,
  ortho.cov,
  bw.cov,
  cumulative
)

.tvOLS.cv(
  bw,
  x,
  y,
  z = NULL,
  cv.block = 0,
  est = c("lc", "ll"),
  tkernel = c("Triweight", "Epa", "Gaussian"),
  singular.ok = TRUE
)

.tvRE.cv(
  bw,
  x,
  y,
  z = NULL,
  neq,
  obs,
  cv.block = 0,
  est = c("lc", "ll"),
  tkernel = c("Triweight", "Epa", "Gaussian")
)

tvreg.control(maxiter = 100, tol = 1e-05)
}
\arguments{
\item{x}{A matrix.}

\item{bw}{A scalar.}

\item{tkernel}{A character, either "Triweight" (default), "Epa" or "Gaussian" kernel function.}

\item{z}{A vector.}

\item{est}{A character, either "lc" or "ll" for local constant or local linear.}

\item{maxiter}{maximum number of iterations for the iterative FGLS
estimations.}

\item{tol}{tolerance level indicating when to stop the iteration for the iterative FGLS estimations}
}
\value{
A numeric vector.

A scalar with the mean squared error.

A list of the above components.
}
\description{
Listed below are supporting functions for the major methods in tvReg.

Create a list of control pararameters for the \code{\link{tvSURE}} and
\code{\link{tvPLM}} methods.
All control parameters that are not passed to this function are set to
default values.
}
\details{
.kernel calculates the kernel values of a vector and a given bandwidth

If the estimation is iterative FGLS with \code{maxiter}>1, the convergence criterion is
\deqn{\sqrt{ \frac{ \sum_{i, j}
(B_{i,j,g} - B{i, j, g-1})^2 }{ \sum_{i, j} B_{i, j, g-1}^2 }} < \code{tol}}
(\eqn{B_{i, j,g}} is the ith, jth coefficient of the gth iteration step).
}
\keyword{internal}
