% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CurveFuncs.R
\name{disc_value}
\alias{disc_value}
\title{Calculates the present value of a cashflow}
\usage{
disc_value(r, cf, d = 1:length(cf))
}
\arguments{
\item{r}{A rate curve}

\item{cf}{The vector of values corresponding to the cashflow}

\item{d}{The periods on which the cashflow occurs. If missing, it is assumed that cf[i] occurs on period i}
}
\value{
The present value of the cashflow
}
\description{
Calculates the present value of a cashflow
}
\examples{
r <- rate_curve(rates = c(0.1, 0.2, 0.3), rate_type = "zero_eff")
disc_value(r, cf = c(-1, 1.10), d = c(0,1))
disc_value(r, cf = c(-1, 1.15*1.15), d = c(0,2))

}
