% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_parksAndRec.R
\name{theme_parksAndRec}
\alias{theme_parksAndRec}
\title{Parks & Recreation theme}
\usage{
theme_parksAndRec(text.font = NULL, title.font = NULL,
  legend.font = NULL, title.size = 20, text.size = 16,
  subtitle.size = 14, axis.title.size = 14, axis.text.size = 12,
  legend.title.size = 14, legend.text.size = 12, title.color = NULL,
  subtitle.color = NULL, text.color = NULL,
  axis.title.color = "black", axis.text.color = "black",
  legend.title.color = NULL, legend.text.color = NULL,
  legend.position = "bottom", ticks = FALSE)
}
\arguments{
\item{text.font}{text font, Default: NULL}

\item{title.font}{title font, Default: NULL}

\item{legend.font}{legend font, Default: NULL}

\item{title.size}{title font size, Default: 20}

\item{text.size}{text font size, Default: 16}

\item{subtitle.size}{subtitle font size, Default: 14}

\item{axis.title.size}{axis title font size, Default: 14}

\item{axis.text.size}{axis text font size, Default: 12}

\item{legend.title.size}{legend title font size, Default: 14}

\item{legend.text.size}{legend text font size, Default: 12}

\item{title.color}{title color, Default: NULL}

\item{subtitle.color}{subtitle.color, Default: NULL}

\item{text.color}{text color, Default: NULL}

\item{axis.title.color}{axis title color, Default: NULL}

\item{axis.text.color}{axis text color, Default: NULL}

\item{legend.title.color}{legend title color, Default: NULL}

\item{legend.text.color}{legend text color, Default: NULL}

\item{legend.position}{legend position, Default: "bottom"}

\item{ticks}{add axis ticks, Default: FALSE}
}
\description{
Parks & Recreation theme, Recommended font: "Titillium Web"
}
\details{
Actual font: 'Champion HTF-Heavyweight'
}
\examples{
library(ggplot2)

ggplot(airquality, aes(x = Day, y = Temp,
     group = as.factor(Month), color = as.factor(Month))) +
     geom_point(size = 2.5) +
     scale_color_parksAndRec() +
     theme_parksAndRec()
}
\seealso{
[ggplot2::theme]
}
