#' Nash–Sutcliffe Efficiency
#'
#' Function for calculating the Nash–Sutcliffe efficiency.
#'
#' @import data.table
#' @param x a data.table generated by \code{\link{fldmean}}
#' @param ref a data.table with data used for evaluation
#' @return numeric
#' @export

nse <- function(x, ref){
  setnames(x, 'value', 'forecast')
  setnames(ref, 'value', 'observed')
  dummie_mean <- mean(ref$observed, na.rm = TRUE)
  dummie_table <- merge(ref, x, by = 'date', allow.cartesian = TRUE)
  dummie_table <- dummie_table[, t1 := (observed - forecast)^2
                               ][, t2 := (observed -dummie_mean)^2]
  dummie_t1 <- sum(dummie_table$t1, na.rm = TRUE)
  dummie_t2 <- sum(dummie_table$t2, na.rm = TRUE)
  dummie <- 1 - (dummie_t1/dummie_t2)
  return(dummie)
}