% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoway.R
\name{twoway}
\alias{twoway}
\alias{twoway.default}
\title{Analysis of a two-way table with one observation per cell}
\usage{
twoway(x, ...)

\method{twoway}{default}(x, method = c("mean", "median"), ...,
  name = deparse(substitute(x)), responseName = attr(x, "response"),
  varNames = names(dimnames(x)))
}
\arguments{
\item{x}{a numeric matrix or data frame.}

\item{...}{other arguments passed down}

\item{method}{one of \code{"mean"} or \code{"median"}}

\item{name}{name for the input dataset}

\item{responseName}{name for the response variable}

\item{varNames}{names for the Row and Column variables}
}
\value{
An object of class \code{c("twoway")} with the following named components:
\describe{
 \item{overall}{the fitted constant term.}
 \item{roweff}{the fitted row effects.}
 \item{coleff}{the fitted column effects.}
 \item{residuals}{the residuals.}
 \item{name}{the name of the dataset.}
 \item{rownames}{the names for the rows}
 \item{colnames}{the names for the columns}
 \item{method}{the fitting method}
 \item{varNames}{the names of the row and column variables}
 \item{responseName}{the name of the response variable}
 \item{compValue}{the comparison values, for the diagnostic plot}
 \item{slope}{the slope value, for the diagnostic plot}
 \item{power}{the suggested power transformation, \code{1-slope}}
}

An object of class \code{"twoway"}, but supplemented by additional components used for labeling
}
\description{
Fits an additive model using either row and column means or Tukey's median polish procedure
}
\details{
The \code{rownames(x)} are used as the levels of the row factor and the \code{colnames(x}) are
         the levels of the column factor.
         For a numeric matrix, the function uses the \code{names(dimnames(x))} as the names of these
         variables, and, if present, a \code{responseName} attribute as the name for the response variable.
}
\examples{
data(taskRT)
twoway(taskRT)

}
\references{
Tukey, J. W. (1977). \emph{Exploratory Data Analysis}, Reading MA: Addison-Wesley.
            Friendly, M. (1991). \emph{SAS System for Statistical Graphics} Cary, NC: SAS Institute
}
\seealso{
code{\link{twoway.formula}}, code{\link[stats]{medpolish}}

\code{\link{medianfit}}, \code{\link{meanfit}}
}
\author{
Michael Friendly
}
