% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R, R/printMethods.R,
%   R/quantileResidualTests.R
\name{plot.qrtest}
\alias{plot.qrtest}
\alias{print.qrtest}
\alias{quantileResidualTests}
\title{Quantile residual tests for GMAR, StMAR or G-StMAR model}
\usage{
\method{plot}{qrtest}(x, ...)

\method{print}{qrtest}(x, ..., digits = 3)

quantileResidualTests(gsmar, lagsAC = c(1, 2, 5, 10), lagsCH = lagsAC,
  nsimu = 2000, printRes = TRUE)
}
\arguments{
\item{x}{object of class \code{'qrtest'} generated by the function \code{quantileResidualTests()}.}

\item{...}{graphical parameters passed to \code{segments} in \code{plot.qrtest}.
Currectly not used in \code{print.qrtest}}

\item{digits}{number of decimals to print}

\item{gsmar}{object of class \code{'gsmar'}, generated by function \code{fitGSMAR()} or \code{GSMAR()}.}

\item{lagsAC}{a numeric vector of positive integers specifying the lags for which autocorrelation is tested.}

\item{lagsCH}{a numeric vector of positive integers specifying the lags for which conditional heteroscedasticy is tested.}

\item{nsimu}{a positive integer specifying to how many simulated observations the covariance matrix Omega should be based on.
If smaller than data size, then omega will be based on the given data.}

\item{printRes}{a logical argument defining whether results should be printed or not.}
}
\value{
Returns an object of class \code{'qrtest'} containing the test results in data frames. In the cases
  of autocorrelation and conditional heteroscedasticity tests, the returned object also contains the
  associated individual statistics and their standard errors, discussed by \emph{Kalliovirta (2012)} at
  the pages 369-370.
}
\description{
\code{quantileResidualTests} performs quantile residual tests for GMAR, StMAR or G-StMAR model,
 testing normality, autocorrelation and conditional heteroscedasticy.
}
\details{
For details about the quantile residual tests see the cited article by \emph{Kalliovirta (2012)}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: plot p-values of the autocorrelation and conditional
heteroskedasticity tests.

\item \code{print}: print method for class 'qrtest'
}}

\section{Suggested packages}{

  Install the suggested package "gsl" for faster evaluations in the cases of StMAR and G-StMAR models.
  For large StMAR and G-StMAR models with large data the evaluations may take significantly long time without
  the package "gsl".
}

\examples{
\donttest{
# GMAR model
params12 <- c(1.12, 0.91, 0.29, 4.53, 0.70, 3.21, 0.84)
gmar12 <- GSMAR(VIX, 1, 2, params12)
qrtest12 <- quantileResidualTests(gmar12)
plot(qrtest12)

# Restricted GMAR model
params12r <- c(1.4, 1.8, 0.88, 0.29, 3.18, 0.84)
gmar12r <- GSMAR(data=VIX, p=1, M=2, params=params12r, model="GMAR",
 restricted=TRUE)
qrtest12r <- quantileResidualTests(gmar12r, lagsAC=1:10, nsimu=1)
plot(qrtest12r)

# StMAR model
params12t <- c(1.38, 0.88, 0.27, 3.8, 0.74, 3.15, 0.8, 100, 3.6)
stmar12 <- GSMAR(data=VIX, p=1, M=2, params=params12t, model="StMAR")
quantileResidualTests(stmar12, lagsAC=c(1, 2, 5), nsimu=1)

# G-StMAR model
params12gs <- c(1.38, 0.88, 0.27, 3.8, 0.74, 3.15, 0.8, 3.6)
gstmar12 <- GSMAR(data=VIX, p=1, M=c(1, 1), params=params12gs,
 model="G-StMAR")
quantileResidualTests(gstmar12, lagsAC=c(1, 3), lagsCH=1:2, nsimu=1)

# Such StMAR(3,2) that the AR coefficients are restricted to be
# the same for both regimes and that the second AR coefficients are
# constrained to zero.
params32trc <- c(2.2, 1.8, 0.88, -0.03, 2.4, 0.27, 0.40, 3.9, 1000)
stmar32rc <- GSMAR(data=VIX, p=3, M=2, params=params32trc, model="StMAR",
 restricted=TRUE, constraints=matrix(c(1, 0, 0, 0, 0, 1), ncol=2))
quantileResidualTests(stmar32rc, lagsAC=c(1, 3), nsimu=1)
}
}
\references{
\itemize{
   \item Galbraith, R., Galbraith, J. 1974. On the inverses of some patterned matrices arising
           in the theory of stationary time series. \emph{Journal of Applied Probability} \strong{11}, 63-71.
   \item Kalliovirta L. (2012) Misspecification tests based on quantile residuals.
           \emph{The Econometrics Journal}, \strong{15}, 358-393.
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Lutkepohl H. 2005. New Introduction to Multiple Time Series Analysis.
           \emph{Springer}.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item There are currently no published references for G-StMAR model, but it's a straight forward generalization with
           theoretical properties similar to GMAR and StMAR models.
 }
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{diagnosticPlot}}, \code{\link{predict.gsmar}},
}
