% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counterfactual_model.R
\name{run_rf}
\alias{run_rf}
\title{Run random forest model with ranger}
\usage{
run_rf(train, test, model_params, alpha, calc_shaps)
}
\arguments{
\item{train}{Dataframe of train data as returned by the \code{\link[=split_data_counterfactual]{split_data_counterfactual()}}
function.}

\item{test}{Dataframe of test data as returned by the \code{\link[=split_data_counterfactual]{split_data_counterfactual()}}
function.}

\item{model_params}{list of hyperparameters to use in ranger call. See \code{\link[ranger:ranger]{ranger:ranger()}} for options.}

\item{alpha}{Confidence level of the prediction interval between 0 and 1.}

\item{calc_shaps}{Boolean value. If TRUE, calculate SHAP values for the
method used and format them so they can be visualised with \code{\link[shapviz:sv_importance]{shapviz:sv_importance()}} and
\code{\link[shapviz:sv_dependence]{shapviz:sv_dependence()}}.
The SHAP values are generated for a subset (or all, depending on the size of the dataset) of the
test data.}
}
\value{
List with data frame of predictions and model
}
\description{
This function trains a random forest model (ranger) on the
specified training dataset and makes predictions on the test dataset in a
counterfactual scenario. The model uses meteorological variables and temporal features.
}
\details{
Note: Runs the random forest model for individualised use with own data pipeline.
Otherwise use \code{\link[=run_counterfactual]{run_counterfactual()}}  to call this function.
}
