% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{solution_statistics}
\alias{solution_statistics}
\title{Calculate Solution Statistics}
\usage{
solution_statistics(parameters, cfg)
}
\arguments{
\item{parameters}{list of parameter estimates}

\item{cfg}{ubiquity system object}
}
\value{
list containing information about the provided estimates
}
\description{
Attempts to determine the variance/covariance matrix,
confidence intervals and CV percent for a list of parameter estimates 
\code{parameters}. This method was taken from the ADAPT 5 User's Guide
chapter 3.
}
\details{
The returned list has the following format:
\itemize{
  \item \code{objective} - objective function value
  \item \code{num_observations} - number of observations
  \item \code{degrees_of_freedom} - degrees of freedom 
  \item \code{aic} - Akaike information criterion 
  \item \code{bic} - Bayesian (Schwarz) information criterion 
  \item \code{covariance} - variance covariance matrix
  \item \code{wls} - defined for weighted least squares objective with the following elements:
  \itemize{
    \item \code{jacobian}  - Jacobian matrix
    \item \code{weights}  - diagonal matrix of weights
    \item \code{error_variance}  - diagonal matrix of variances
  }
  \item \code{ml} - defined for maximum likelihood objective with the following elements:
  \itemize{
    \item \code{M} - Jacobian matrix with block for variance parameters
  }
  \item \code{coefficient_of_variation$pname} - CV percent for parameter \code{pname}
  \item \code{confidence_interval$lower_bound$pname} - Lower bound of the confidence interval for \code{pname}
  \item \code{confidence_interval$upper_bound$pname} - Upper bound of the confidence interval for \code{pname}
}
}
\seealso{
Vignette on estimation (\code{vignette("Estimation", package = "ubiquity")})
}
\keyword{internal}
