% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{priors}
\alias{priors}
\alias{normal}
\alias{uniform}
\alias{student_t}
\alias{logistic}
\alias{cauchy}
\alias{gamma}
\alias{laplace}
\title{Prior distributions}
\usage{
normal(location = 0, scale = 2.5, autoscale = TRUE)

uniform(lower = -5, upper = 5)

student_t(df = 1, location = 0, scale = 2.5, autoscale = TRUE)

logistic(location = 0, scale = 1)

cauchy(location = 0, scale = 2.5, autoscale = TRUE)

gamma(shape = 1, rate = 1)

laplace(location = 0, scale = 2.5, autoscale = TRUE)
}
\arguments{
\item{location}{The mean of the distribution. If setting the priors for
regression coefficients, this can be a single value, or multiple values,
one per coefficient}

\item{scale}{The standard deviation of the distribution. If setting the priors
for regression coefficients, this can be a single value, or multiple values,
one per coefficient}

\item{autoscale}{If \code{TRUE}, ubms will automatically adjust priors
for each regression coefficient relative to its corresponding covariate x.
Specifically, the prior for a given coefficient will be divided by
sd(x). This helps account for covariates with very different magnitudes
in the same model. If your data are already standardized (e.g. with use of
\code{scale()}), this will have minimal effect as sd(x) will be
approximately 1. Standardizing your covariates is highly recommended.}

\item{lower}{The lower bound for the uniform distribution}

\item{upper}{The upper bound for the uniform distribution}

\item{df}{The number of degrees of freedom for the Student-t distribution}

\item{shape}{The gamma distribution shape parameter}

\item{rate}{The gamma distribution rate parameter (1/scale)}
}
\value{
A \code{list} containing prior settings used internally by \code{ubms}.
}
\description{
Specify prior distributions and associated parameters for use in
\code{ubms} models.
}
\examples{
normal()

}
