% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlp_flow.R
\name{dtm_remove_terms}
\alias{dtm_remove_terms}
\title{Remove terms from a Document-Term-Matrix and keep only documents which have a least some terms}
\usage{
dtm_remove_terms(dtm, terms)
}
\arguments{
\item{dtm}{an object returned by \code{\link{document_term_matrix}} or an object of class DocumentTermMatrix}

\item{terms}{a character vector of terms which are in \code{colnames(dtm)} and which should be removed}
}
\value{
a sparse Matrix as returned by \code{sparseMatrix} or an object of class \code{DocumentTermMatrix} 
where the indicated terms are removed as well as documents with no terms whatsoever
}
\description{
Remove terms from a Document-Term-Matrix and keep only documents which have a least some terms
}
\examples{
data(brussels_reviews_anno)
x <- subset(brussels_reviews_anno, xpos == "NN")
x <- x[, c("doc_id", "lemma")]
x <- document_term_frequencies(x)
dtm <- document_term_matrix(x)
dim(dtm)
dtm <- dtm_remove_terms(dtm, terms = c("appartement", "casa", "centrum", "ciudad"))
dim(dtm)
}
