% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uis_get_indicators.R
\name{uis_get_indicators}
\alias{uis_get_indicators}
\title{Get indicator definitions from UIS API}
\usage{
uis_get_indicators(
  version = NULL,
  disaggregations = FALSE,
  glossary_terms = FALSE
)
}
\arguments{
\item{version}{Character. The API version to use. If NULL (default), the
API's default version will be used. See \link{uis_get_versions} for a list
of supported versions.}

\item{disaggregations}{Logical. If TRUE, includes disaggregation information
for indicators. Default is FALSE.}

\item{glossary_terms}{Logical. If TRUE, includes glossary terms associated
with indicators. Default is FALSE.}
}
\value{
A data frame with information about indicators:
\item{indicator_id}{Character. The unique identifier for the indicator.}
\item{indicator_name}{Character. The name of the indicator.}
\item{theme}{Character. The theme of the indicator.}
\item{last_data_update}{Date. The last update date.}
\item{last_data_update_description}{Character. A description about the
last update date.}
\item{data_availability}{List column. Contains nested information about
data availability, including total record count and timeline min/max years.}
\item{entity_types}{List column. Contains information about entity types
associated with the indicator.}
}
\description{
Retrieves information about indicators available in the UNESCO Institute for
Statistics (UIS) API.
}
\examples{
\donttest{
# Download indicators
uis_get_indicators()

# Download indicators with glossary terms and disaggregations
uis_get_indicators(disaggregations = TRUE, glossary_terms = TRUE)
}

}
