% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis.R
\name{ukb_icd_diagnosis}
\alias{ukb_icd_diagnosis}
\title{Retrieves diagnoses for an individual.}
\usage{
ukb_icd_diagnosis(data, id, icd.version = NULL)
}
\arguments{
\item{data}{A UKB dataset (or subset) created with \code{\link{ukb_df}}.}

\item{id}{An individual's id, i.e., their unique eid reference number.}

\item{icd.version}{The ICD version (or revision) number, 9 or 10.}
}
\description{
Retrieves diagnoses for an individual.
}
\examples{
\dontrun{
ukb_icd_diagnosis(my_ukb_data, id = "123456", icd.version = 10)
}

}
\seealso{
\code{\link{ukb_df}}, \code{\link{ukb_icd_code_meaning}}, \code{\link{ukb_icd_keyword}}, \code{\link{ukb_icd_prevalence}}
}
