% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{ukb_defunct}
\alias{ukb_defunct}
\title{Defunct genetic metadata functions}
\usage{
ukb_defunct()
}
\description{
The genetic metadata functions were written to retrieve genetic metadata from the phenotype file for the \href{http://biobank.ctsu.ox.ac.uk/crystal/label.cgi?id=199001}{interim genotype release}. \strong{The fields retrieved became obselete when the full genotyping results (500K individuals) were released at the end of 2017.} With the release of the full genotyping results, sample QC (ukb_sqc_v2.txt) and marker QC (ukb_snp_qc.txt) data are now supplied as separate files. The contents of these files, along with all other genetic files are described fully in \href{https://biobank.ctsu.ox.ac.uk/crystal/refer.cgi?id=531}{UKB Resource 531}.
\itemize{
\item ukb_gen_meta(data)
\item ukb_gen_pcs(data)
\item ukb_gen_excl(data)
\item ukb_gen_rel(data)
\item ukb_gen_het(data, all.het = FALSE)
\item ukb_gen_excl_to_na(data, x, ukb.id = "eid", data.frame = FALSE)
\item ukb_gen_write_plink_excl(path)
}
}
\details{
See also lists new functionality that works with the files described in \href{https://biobank.ctsu.ox.ac.uk/crystal/refer.cgi?id=531}{UKB Resource 531}.
}
\seealso{
\code{\link{ukb_gen_sqc_names}}, \code{\link{ukb_gen_rel_count}}, \code{\link{ukb_gen_related_with_data}}, \code{\link{ukb_gen_samples_to_remove}}
}
