% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{ukb_gen_excl_to_na}
\alias{ukb_gen_excl_to_na}
\title{Inserts NA into phenotype for genetic metadata exclusions}
\usage{
ukb_gen_excl_to_na(data, x, ukb.id = "eid", data.frame = FALSE)
}
\arguments{
\item{data}{A UKB dataset created with \code{\link{ukb_df}}.}

\item{x}{The phenotype to be updated (as it is named in \code{data}) e.g. "height"}

\item{ukb.id}{The name of the ID variable in \code{data}. Default is "eid"}

\item{data.frame}{A logical vector indicating whether to return a vector or a data.frame (header: id, meta_excl, pheno, pheno_meta_na) containing the original and updated variable. Default = FALSE returns a vector.}
}
\description{
\strong{Defunct. See help("ukb_defunct")}.

Replaces data values in a vector (a UKB phenotype) with \code{NA} where the sample is to-be-excluded, i.e., is either a UKB recommended exclusion, a heterozygosity outlier, a genetic ethnicity outlier, or a randomly-selected member of a related pair.
}
\examples{
\dontrun{
my_ukb_data$height_excl_na <- ukb_gen_excl_to_na(my_ukb_data, x = "height")
}
}
\seealso{
\code{\link{ukb_gen_write_plink_excl}}
}
