% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbourhood-boundary.R
\name{ukc_neighbourhood_boundary}
\alias{ukc_neighbourhood_boundary}
\title{Specific Neighbourhood Boundary}
\usage{
ukc_neighbourhood_boundary(force, neighbourhood_id)
}
\arguments{
\item{force}{A string containing the name of the police force to return
neighbourhoods for. Must be specified, and is not case sensitive.}

\item{neighbourhood_id}{A string containing the ID of a given neighbourhood,
returned from \code{\link[=ukc_neighbourhoods]{ukc_neighbourhoods()}}. If missing, returns all neighbourhoods
for the specified police force, using \code{\link[=ukc_neighbourhoods]{ukc_neighbourhoods()}}.}
}
\value{
A \code{tibble} with the lat/lng boundaries for a specific neighbourhood.
}
\description{
Data on a specific neighbourhood boundary, using lat/lng pairs.
}
\examples{
\dontrun{
borders <- ukc_neighbourhood_boundary("dorset", "55.CR3001")
}

}
\seealso{
\code{\link[=ukc_neighbourhoods]{ukc_neighbourhoods()}}

\code{\link[=ukc_neighbourhood_specific]{ukc_neighbourhood_specific()}}

\code{\link[=ukc_neighbourhood_location]{ukc_neighbourhood_location()}}
}
