% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_add_variances}
\alias{umx_add_variances}
\title{umx_add_variances}
\usage{
umx_add_variances(model, add.to, values = NULL, free = NULL)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to add variances to}

\item{add.to}{= List of variables to create variance for}

\item{values}{= List of values (default = NULL)}

\item{free}{= List of variables to create variance for (default = NULL)}
}
\value{
- \code{\link{mxModel}}
}
\description{
Convenience function to save the user specifying mxPaths adding variance to each variable
}
\examples{
require(OpenMx)
data(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
 manifestVars = names(demoOneFactor),
 latentVars = "g",
	mxPath(from = "g", to = names(demoOneFactor), values= .1),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
umx_show(m1, matrices = "S") # variables lack variance :-(
m1 = umx_add_variances(m1, add.to = names(demoOneFactor))
m1 = umx_add_variances(m1, add.to = "g", FALSE, 1)
umx_show(m1, matrices = "S")
# Note: latent g has been treated like the manifests...
# umxFixLatents() will take care of this for you...
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
umxSummary(m1)
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}, \url{http://openmx.psyc.virginia.edu}
}
\seealso{
Other Miscellaneous Functions: \code{\link{umxEval}};
  \code{\link{umxJiggle}}; \code{\link{umx_APA_pval}};
  \code{\link{umx_apply}}; \code{\link{umx_check_model}};
  \code{\link{umx_check_multi_core}};
  \code{\link{umx_checkpoint}},
  \code{\link{umx_set_checkpoint}};
  \code{\link{umx_check}};
  \code{\link{umx_default_option}};
  \code{\link{umx_explode}};
  \code{\link{umx_get_CI_as_APA_string}};
  \code{\link{umx_get_bracket_addresses}};
  \code{\link{umx_get_checkpoint}};
  \code{\link{umx_get_cores}};
  \code{\link{umx_get_optimizer}};
  \code{\link{umx_has_CIs}};
  \code{\link{umx_has_been_run}};
  \code{\link{umx_has_means}};
  \code{\link{umx_has_square_brackets}};
  \code{\link{umx_is_MxMatrix}};
  \code{\link{umx_is_MxModel}}; \code{\link{umx_is_RAM}};
  \code{\link{umx_is_cov}};
  \code{\link{umx_is_endogenous}};
  \code{\link{umx_is_exogenous}};
  \code{\link{umx_is_ordered}}; \code{\link{umx_msg}};
  \code{\link{umx_names}}; \code{\link{umx_object_as_str}};
  \code{\link{umx_paste_names}}; \code{\link{umx_print}};
  \code{\link{umx_rename}}; \code{\link{umx_reorder}};
  \code{\link{umx_rot}}; \code{\link{umx_set_cores}};
  \code{\link{umx_set_optimizer}};
  \code{\link{umx_string_to_algebra}};
  \code{\link{umx_trim}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

