% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umxEval}
\alias{umxEval}
\title{umxEval}
\usage{
umxEval(expstring, model, compute = FALSE, show = FALSE)
}
\arguments{
\item{expstring}{an expression string, i.e, "a + b"}

\item{model}{an \code{\link{mxModel}} to evaluate in}

\item{compute}{Whether to compute the result or not (default = FALSE)}

\item{show}{Whether to show??? (default = FALSE)}
}
\value{
- an openmx algebra (formula)
}
\description{
Takes an expression as a string, and evaluates it as an expression in model, optionally computing the result.
# TODO Currently broken...
}
\examples{
m1 = mxModel("fit",
		mxMatrix("Full", nrow = 1, ncol = 1, free = TRUE, values = 1, name = "a"),
		mxMatrix("Full", nrow = 1, ncol = 1, free = TRUE, values = 2, name = "b"),
		mxAlgebra(a \%*\% b, name = "ab"),
		mxConstraint(ab == 35, name = "maxHours"),
		mxAlgebraObjective(algebra = "ab", numObs= NA, numStats = NA)
	)
m1 = mxRun(m1)
mxEval(list(ab = ab), m1)
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
- \code{\link{umxLabel}}, \code{\link{umxRun}}, \code{\link{umxValues}}

Other Miscellaneous Functions: \code{\link{umxJiggle}};
  \code{\link{umx_APA_pval}};
  \code{\link{umx_add_variances}}; \code{\link{umx_apply}};
  \code{\link{umx_check_OS}};
  \code{\link{umx_check_model}};
  \code{\link{umx_check_multi_core}};
  \code{\link{umx_checkpoint}},
  \code{\link{umx_set_checkpoint}};
  \code{\link{umx_check}};
  \code{\link{umx_default_option}};
  \code{\link{umx_get_CI_as_APA_string}};
  \code{\link{umx_get_bracket_addresses}};
  \code{\link{umx_get_checkpoint}};
  \code{\link{umx_get_cores}};
  \code{\link{umx_get_optimizer}};
  \code{\link{umx_has_CIs}};
  \code{\link{umx_has_been_run}};
  \code{\link{umx_has_means}};
  \code{\link{umx_has_square_brackets}};
  \code{\link{umx_is_MxMatrix}};
  \code{\link{umx_is_MxModel}}; \code{\link{umx_is_RAM}};
  \code{\link{umx_is_cov}};
  \code{\link{umx_is_endogenous}};
  \code{\link{umx_is_exogenous}};
  \code{\link{umx_is_ordered}};
  \code{\link{umx_object_as_str}};
  \code{\link{umx_reorder}}; \code{\link{umx_set_cores}};
  \code{\link{umx_set_optimizer}};
  \code{\link{umx_standardize_IP}};
  \code{\link{umx_string_to_algebra}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

