% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umxSummaryIP}
\alias{umxSummaryIP}
\alias{umxSummary.MxModelIP}
\title{Present the results of an independent-pathway twin model in table and graphical form}
\usage{
umxSummaryIP(model, digits = 2, file = getOption("umx_auto_plot"),
  returnStd = FALSE, std = TRUE, showRg = FALSE, comparison = NULL,
  CIs = FALSE, ...)
}
\arguments{
\item{model}{A fitted \code{\link{umxIP}} model to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{std}{= Whether to show the standardized model (TRUE)}

\item{showRg}{= whether to show the genetic correlations (FALSE)}

\item{comparison}{Whether to run mxCompare on a comparison model (NULL)}

\item{CIs}{Confidence intervals (F)}

\item{...}{Optional additional parameters}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarize a Independent Pathway model, as returned by \code{\link{umxIP}}
}
\examples{
require(umx)
data(GFF) # family function and well-being data
mzData <- subset(GFF, zyg_2grp == "MZ")
dzData <- subset(GFF, zyg_2grp == "DZ")
selDVs = c("hap", "sat", "AD") # These will be expanded into "hap_T1" "hap_T2" etc.
m1 = umxIP(selDVs = selDVs, sep = "_T", dzData = dzData, mzData = mzData)
umxSummaryIP(m1)
plot(m1)
\dontrun{
umxSummaryIP(m1, digits = 2, file = "Figure3", showRg = FALSE, CIs = TRUE);
}
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
- \code{\link{umxIP}()}, \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

Other Twin Modeling Functions: \code{\link{umxACE_cov_fixed}},
  \code{\link{umxACEcov}}, \code{\link{umxACEold}},
  \code{\link{umxACEv}}, \code{\link{umxACE}},
  \code{\link{umxCPold}}, \code{\link{umxCP}},
  \code{\link{umxGxE_window}}, \code{\link{umxGxEbiv}},
  \code{\link{umxGxE}}, \code{\link{umxIPold}},
  \code{\link{umxIP}}, \code{\link{umxSexLim}},
  \code{\link{umxSimplex}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxEbiv}},
  \code{\link{umxSummaryGxE}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umxSummarySimplex}}, \code{\link{umx}},
  \code{\link{xmu_twin_check}}
}
\concept{Twin Modeling Functions}
