% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxSimplex.R
\name{umx_standardize_Simplex}
\alias{umx_standardize_Simplex}
\title{Standardize a Simplex twin model}
\usage{
umx_standardize_Simplex(model, ...)
}
\arguments{
\item{model}{an \code{\link{umxSimplex}} model to standardize}

\item{...}{Other options}
}
\value{
- Standardized Simplex \code{\link{umxSimplex}} model
}
\description{
umx_standardize_Simplex
}
\examples{
data(iqdat)
mzData = subset(iqdat, zygosity == "MZ")
dzData = subset(iqdat, zygosity == "DZ")
m1  = umxSimplex(selDVs = paste0("IQ_age", 1:4), sep = "_T", dzData = dzData, mzData = mzData)
std = umx_standardize_Simplex(m1)
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other zAdvanced Helpers: \code{\link{umx_merge_CIs}},
  \code{\link{umx_standardize_ACEcov}},
  \code{\link{umx_standardize_ACEv}},
  \code{\link{umx_standardize_ACE}},
  \code{\link{umx_standardize_CP}},
  \code{\link{umx_standardize_IP}},
  \code{\link{umx_stash_CIs}}, \code{\link{umx}}
}
