% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.R
\name{umx_r_test}
\alias{umx_r_test}
\title{Test the difference between correlations for significance.}
\usage{
umx_r_test(
  data = NULL,
  vars = vars,
  alternative = c("two.sided", "greater", "less")
)
}
\arguments{
\item{data}{The dataset.}

\item{vars}{Four variables forming the two pairs of columns: "j & k" and "h & m".}

\item{alternative}{A two (default) or one-sided (greater less) test.}
}
\value{
cocor result.
}
\description{
\code{umx_r_test} is a wrapper around the cocor test of difference between correlations.
}
\details{
Currently \code{umx_r_test} handles the test of whether \code{r.jk} and \code{r.hm} differ in magnitude.
i.e, two non-overlapping (no variable in common) correlations in the same dataset.
In the future it will be expanded to handle overlapping correlations, and to take correlation matrices as input.
}
\examples{
# Is the correlation of mpg with cylinder count different from that 
# obtaining between disp and hp?
vars = c("mpg", "cyl", "disp", "hp")
umx_r_test(mtcars, vars)
}
\seealso{
Other Miscellaneous Stats Helpers: 
\code{\link{FishersMethod}()},
\code{\link{SE_from_p}()},
\code{\link{oddsratio}()},
\code{\link{reliability}()},
\code{\link{umxCov2cor}()},
\code{\link{umxHetCor}()},
\code{\link{umxWeightedAIC}()},
\code{\link{umx_apply}()},
\code{\link{umx_cor}()},
\code{\link{umx_means}()},
\code{\link{umx_round}()},
\code{\link{umx_scale}()},
\code{\link{umx_var}()},
\code{\link{umx}}
}
\concept{Miscellaneous Stats Helpers}
