% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_strings2numeric}
\alias{umx_strings2numeric}
\title{A wrapper to map columns of strings to numeric.}
\usage{
umx_strings2numeric(df, cols = NA, mapStrings = NULL)
}
\arguments{
\item{df}{The df}

\item{cols}{(optional) list of columns (default = use all)}

\item{mapStrings}{legal strings which will be mapped in order to numbers.}
}
\value{
\itemize{
\item df
}
}
\description{
If you give one column name, this is changed to numeric, and returned as a \strong{vector}.
If you give multiple column names, or don't set cols, each is changed to numeric, and the updated \strong{data.frame} is returned.
}
\examples{
tmp = data.frame(x=letters)
umx_strings2numeric(tmp, mapStrings = letters)
umx_strings2numeric(tmp, cols= "x", mapStrings = letters)
}
\seealso{
Other Data Functions: 
\code{\link{noNAs}()},
\code{\link{prolific_anonymize}()},
\code{\link{prolific_check_ID}()},
\code{\link{prolific_read_demog}()},
\code{\link{umxFactor}()},
\code{\link{umxHetCor}()},
\code{\link{umx_as_numeric}()},
\code{\link{umx_cont_2_quantiles}()},
\code{\link{umx_lower2full}()},
\code{\link{umx_make_MR_data}()},
\code{\link{umx_make_TwinData}()},
\code{\link{umx_make_fake_data}()},
\code{\link{umx_make_raw_from_cov}()},
\code{\link{umx_merge_randomized_columns}()},
\code{\link{umx_polychoric}()},
\code{\link{umx_polypairwise}()},
\code{\link{umx_polytriowise}()},
\code{\link{umx_read_lower}()},
\code{\link{umx_rename}()},
\code{\link{umx_reorder}()},
\code{\link{umx_score_scale}()},
\code{\link{umx_select_valid}()},
\code{\link{umx_stack}()},
\code{\link{umx}}
}
\concept{Data Functions}
