% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{deg2rad}
\alias{deg2rad}
\title{Convert Degrees to Degrees}
\usage{
deg2rad(deg)
}
\arguments{
\item{deg}{The value in degrees you wish to convert to radians}
}
\value{
\itemize{
\item value in radians
}
}
\description{
A helper to convert degrees (360 in  a circle) to Rad (\eqn{2\pi}
in a circle).

\emph{note}: R's trig functions, e.g. \code{\link[=sin]{sin()}} use Radians for input!

The formula is radians = \eqn{deg x 180/\pi}.
\itemize{
\item 180 Degrees is equal to \eqn{\pi} radians.
\item 1 Rad = \eqn{180/\pi} degrees = ~ 57.296 degrees.
}
}
\examples{
deg2rad(180) == pi # TRUE!
}
\references{
\url{https://en.wikipedia.org/wiki/Radian}
}
\seealso{
\itemize{
\item \code{\link[=rad2deg]{rad2deg()}}, \code{\link[=sin]{sin()}}
}

Other Miscellaneous Functions: 
\code{\link{fin_JustifiedPE}()},
\code{\link{fin_NI}()},
\code{\link{fin_interest}()},
\code{\link{fin_percent}()},
\code{\link{fin_ticker}()},
\code{\link{fin_valuation}()},
\code{\link{rad2deg}()},
\code{\link{umxBrownie}()}
}
\concept{Miscellaneous Functions}
