% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxCLPM.R
\name{xmu_scale_wide_data}
\alias{xmu_scale_wide_data}
\title{Scale Wide Data Function}
\usage{
xmu_scale_wide_data(data)
}
\arguments{
\item{data}{A data frame with at least two columns. The columns to be scaled
should contain numeric values.}
}
\value{
A data frame with the same number of columns as the input data frame,
containing the scaled values. The resulting column names will match
the original data column names, excluding any non-numeric columns.
}
\description{
This function scales the values in a wide format data frame and returns
a scaled wide format data frame with the same structure as the original,
excluding the original non-numeric values.
}
\details{
The function first checks if the input is a data frame and that it contains 
at least two columns. It then adds a row identifier (`row_id`) to facilitate 
reshaping. The data is reshaped to a long format, where the numeric values are 
scaled using the `scale` function. After scaling, the function reshapes the data 
back to wide format. The resultant scaled values replace the original values, 
and any identifiers or non-numeric columns are removed.
}
\examples{
# Example usage
data <- data.frame(
  time1 = c(2, 4, 6, 8, 10),
  time2 = c(5, 7, 9, 11, 13),
  time3 = c(1, 3, 5, 7, 9)
)
scaled_data <- xmu_scale_wide_data(data)
print(scaled_data)

}
\seealso{
\code{\link{scale}} for details on the scaling method used.
}
