% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_run_modify.R
\name{umxSuperModel}
\alias{umxSuperModel}
\title{Make a multi-group model}
\usage{
umxSuperModel(
  name = "super",
  ...,
  autoRun = getOption("umx_auto_run"),
  tryHard = c("no", "yes", "ordinal", "search"),
  std = FALSE
)
}
\arguments{
\item{name}{The name for the container model (default = 'super')}

\item{...}{Models forming the multiple groups contained in the supermodel.}

\item{autoRun}{Whether to run the model (default), or just to create it and return without running.}

\item{tryHard}{Default ('no') uses normal mxRun. "yes" uses mxTryHard. Other options: "ordinal", "search"}

\item{std}{Show standardized parameters, raw (default), or just the fit indices (null)}
}
\value{
\itemize{
\item \code{\link[=mxModel]{mxModel()}}
}
}
\description{
\code{umxSuperModel} takes 1 or more models and wraps them in a supermodel with a
\code{\link[=mxFitFunctionMultigroup]{mxFitFunctionMultigroup()}} fit function that minimizes the sum of the
fits of the sub-models.

\emph{note}: Any duplicate model-names are renamed to be unique by suffixing \verb{_1} etc.
}
\examples{

\dontrun{
library(umx)
# Create two sets of data in which X & Y correlate ~ .4 in both datasets.
manifests = c("x", "y")
tmp = umx_make_TwinData(nMZpairs = 100, nDZpairs = 150, 
		AA = 0, CC = .4, EE = .6, varNames = manifests)

# Group 1
grp1   = tmp[tmp$zygosity == "MZ", manifests]
g1Data = mxData(cov(grp1), type = "cov", numObs = nrow(grp1), means=umx_means(grp1))

# Group 2
grp2   = tmp[tmp$zygosity == "DZ", manifests]
g2Data = mxData(cov(grp2), type = "cov", numObs = nrow(grp2), means=umx_means(grp2))


# Model 1 (could add autoRun = FALSE if you don't want to run this as it is being built)
m1 = umxRAM("m1", data = g1Data,
	umxPath("x", to = "y", labels = "beta"),
	umxPath(var = manifests, labels = c("Var_x", "Resid_y_grp1")),
	umxPath(means = manifests, labels = c("Mean_x", "Mean_y"))
)

# Model 2
m2 = umxRAM("m2", data = g2Data,
	umxPath("x", to = "y", labels = "beta"),
	umxPath(var = manifests, labels=c("Var_x", "Resid_y_grp2")),
	umxPath(means = manifests, labels=c("Mean_x", "Mean_y"))
)

# Place m1 and m2 into a supermodel, and autoRun it
# NOTE: umxSummary is only semi-smart/certain enough to compute saturated models etc
# and report multiple groups correctly.

m3 = umxSuperModel('top', m1, m2)

umxSummary(m3, std= TRUE)

# |name         | Std.Estimate| Std.SE|CI                |
# |:------------|------------:|------:|:-----------------|
# |beta         |         0.51|   0.05|0.51 [0.41, 0.61] |
# |Var_x        |         1.00|   0.00|1 [1, 1]          |
# |Resid_y_grp1 |         0.74|   0.05|0.74 [0.64, 0.84] |
# |beta         |         0.50|   0.05|0.5 [0.41, 0.6]   |
# |Var_x        |         1.00|   0.00|1 [1, 1]          |
# |Resid_y_grp2 |         0.75|   0.05|0.75 [0.65, 0.84] |

summary(m3)

# ====================================
# = Test models with duplicate names =
# ====================================
data(GFF)
mzData = subset(GFF, zyg_2grp == "MZ")
dzData = subset(GFF, zyg_2grp == "DZ")
selDVs = c("gff", "fc", "qol")
m1 = umxCP(selDVs= selDVs, nFac= 1, dzData= dzData, mzData= mzData, sep= "_T", autoRun= TRUE)
m2 = mxRename(m1, "CP2")
umxModelNames(m1) # "top" "MZ" "DZ"
umxModelNames(m2) # "top" "MZ" "DZ"
super = umxSuperModel("myModel", m1, m2, autoRun = TRUE)
umxModelNames(super)
}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
\itemize{
\item \code{\link[=mxFitFunctionMultigroup]{mxFitFunctionMultigroup()}}, \code{\link[=umxRAM]{umxRAM()}}
}

Other Core Model Building Functions: 
\code{\link{umxMatrix}()},
\code{\link{umxModify}()},
\code{\link{umxPath}()},
\code{\link{umxRAM}()},
\code{\link{umx}}
}
\concept{Core Model Building Functions}
