% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{structuredness}
\alias{structuredness}
\title{Structuredness}
\usage{
structuredness(file_path, signavio = FALSE,
  path_log_already_created = FALSE, generate_new_path_log = FALSE,
  time_to_generate_path_log = 1500)
}
\arguments{
\item{file_path}{document object created using the create_internal_document function}

\item{signavio}{boolean which indicates whether the file stems from signavio}

\item{path_log_already_created}{boolean which indicates whether the path log has already been created before or not. When you are not sure, it is best to use the standard which is false}

\item{generate_new_path_log}{used when it is not possible to save the path log such as with the Rapid miner or in unit tests and examples}

\item{time_to_generate_path_log}{time which is the maximum time to generate a new path log in seconds. The standard setting is 1500 seconds.}
}
\value{
an integer indicating the structuredness
}
\description{
Structuredness measures to which extent the process model can be divided into block structured structures (matching gateways)
Calculation: 1 - size of reduced process model / size of normal process model
To get the reduced process model, the following rules are applied:
-removal of trivial constructs (one incoming and one outgoing sequence flow)
-removal of matching gateways (for loops, this means first a join then a split, for all other gateways, it's the other way around)
-loops with other than XOR-gateways and non-matching gateways are kept
-gateways which are the consequence of multiple start or end events are removed
}
\examples{
\dontshow{file_path <- system.file("extdata", "doc.txt", package="understandBPMN")}
structuredness(file_path, generate_new_path_log = TRUE)
}
