% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_mf.R
\name{annotate_mf}
\alias{annotate_mf}
\title{Annotate meaningful formatting}
\usage{
annotate_mf(xlfilepath, orig, new)
}
\arguments{
\item{xlfilepath}{Path to spreadsheet file (xls or xlsx).}

\item{orig}{Variable to annotate formatting in.}

\item{new}{Name of new variable with cell formatting pasted as a string.}
}
\value{
A tibble with a new column with meaningful formatting embedded as
  text.
}
\description{
Annotate meaningful formatting
}
\details{
At this point, only four popular approaches for meaningful
  formatting (bold, italic, underline, cell highlighting) are hardcoded in
  the function. The HTML code of the fill color used for cell highlighting is
  also appended in the output.
}
\examples{
example_spreadsheet <- system.file("extdata/dog_test.xlsx", package = "unheadr")
annotate_mf(example_spreadsheet, orig = Task, new = Task_annotated)
}
