% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_unity.R
\name{find_unity}
\alias{find_unity}
\title{Find the Unity executable on a machine.}
\usage{
find_unity(unity = NULL, check_path = TRUE)
}
\arguments{
\item{unity}{Character: If provided, this function will quote the provided
string (if necessary) and return it.}

\item{check_path}{Logical: If \code{TRUE}, this function will check if the Unity
executable provided as an argument, environment variable, or option exists.
If it does not, this function will then attempt to find one, and will error
if not found. If \code{FALSE}, this function will never error.}
}
\value{
The path to the Unity executable on the user's machine, as a length-1
character vector.
}
\description{
If the path to Unity is not provided to a function, this function is invoked
to attempt to find it. To do so, it goes through the following steps:
\enumerate{
\item Attempt to load the "unifir_unity_path" environment variable.
\item Attempt to load the "unifir_unity_path" option.
}

Assuming that neither points to an actual file, this function will then
check the default installation paths for Unity on the user's operating
system. If not found, this function will error.
}
\examples{
if (interactive()) {
  try(find_unity())
}
}
\seealso{
Other utilities: 
\code{\link{add_default_player}()},
\code{\link{add_prop}()},
\code{\link{create_unity_project}()},
\code{\link{get_asset}()},
\code{\link{load_png}()},
\code{\link{load_scene}()},
\code{\link{new_scene}()},
\code{\link{read_raw}()},
\code{\link{save_scene}()},
\code{\link{set_active_scene}()},
\code{\link{validate_path}()},
\code{\link{waiver}()}
}
\concept{utilities}
