% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pals.R
\docType{data}
\name{uni_konstanz}
\alias{uni_konstanz}
\title{Default colors of the University of Konstanz.}
\format{
An object of class \code{character} of length 11.
}
\source{
R package \strong{unikn}, 
retrieved from \url{https://CRAN.R-project.org/package=unikn},    
doi \doi{10.5281/zenodo.7096191}. 

Color definitions are based on 
\url{https://www.uni-konstanz.de/en/university/news-and-media/create-online-and-print-media/corporate-design/the-university-of-konstanzs-corporate-design/}  
\url{https://www.uni-konstanz.de/en/university/news-and-media/create-online-and-print-media/corporate-design/colours-for-complex-graphics/}
}
\usage{
uni_konstanz
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_konstanz} provides the default color palette 
of the \href{https://www.uni-konstanz.de/}{University of Konstanz}, Germany.
}
\details{
The \strong{unikn} package provides many additional color palettes for 
the \href{https://www.uni-konstanz.de/}{University of Konstanz}.
}
\examples{
uni_konstanz
seecol(uni_konstanz)  # view color palette
demopal(uni_konstanz, type = 4, main = "Using Uni Konstanz colors", seed = 1)

}
\seealso{
\code{\link{uni_konstanz_pref}} for the preferred colors of the University of Konstanz;  
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other contributed color palettes: 
\code{\link{eth_pal_grey}},
\code{\link{eth_pal_light}},
\code{\link{eth_pal}},
\code{\link{mpg_pal}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_konstanz_pref}},
\code{\link{uni_princeton_0}},
\code{\link{uni_princeton_1}},
\code{\link{uni_princeton_2}}
}
\author{
Hansjoerg Neth, 2022-10-20.
}
\concept{contributed color palettes}
\keyword{datasets}
