% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting-unitquantreg.R
\name{unitquantreg.control}
\alias{unitquantreg.control}
\title{Control parameters for unit quantile regression}
\usage{
unitquantreg.control(
  method = "BFGS",
  hessian = FALSE,
  gradient = TRUE,
  maxit = 5000,
  factr = 1e+07,
  reltol = sqrt(.Machine$double.eps),
  trace = 0L,
  starttests = FALSE,
  dowarn = FALSE,
  ...
)
}
\arguments{
\item{method}{string. Specify the method argument passed to \code{\link[optimx]{optimx}}.}

\item{hessian}{logical. Should use the numerically Hessian matrix to compute
variance-covariance? Default is \code{FALSE}, i.e., use the analytic
Hessian.}

\item{gradient}{logical. Should use the analytic gradient? Default is
\code{TRUE}.}

\item{maxit}{integer. Specify the maximal number of iterations passed to
\code{optimx}.}

\item{factr}{numeric.Controls the convergence of the \code{"L-BFGS-B"} method.}

\item{reltol}{numeric. Relative convergence tolerance passed to \code{\link[optimx]{optimx}}.}

\item{trace}{non-negative integer. If positive, tracing information on the
progress of the optimization is produced.}

\item{starttests}{logical. Should \code{\link[optimx]{optimx}} run tests of the functions
and parameters? Default is \code{FALSE}.}

\item{dowarn}{logical. Show warnings generated by \code{\link[optimx]{optimx}}? Default is
\code{FALSE}.}

\item{...}{arguments passed to \code{\link[optimx]{optimx}}.}
}
\value{
A list with components named as the arguments.
}
\description{
Auxiliary function that control fitting of unit quantile
regression models using \code{\link{unitquantreg}}.
}
\details{
The \code{control} argument of
\code{\link{unitquantreg}} uses the arguments of
\code{\link{unitquantreg.control}}. In particular, the
parameters in \code{\link{unitquantreg}} are estimated by
maximum likelihood using the \code{\link[optimx]{optimx}}, which is a
general-purpose optimization wrapper function that calls other R tools for
optimization, including the existing \code{\link[stats]{optim}} function.
The main advantage of \code{\link[optimx]{optimx}} is to unify the tools
allowing a number of different optimization methods and provide sanity checks.
}
\examples{
data(sim_bounded, package = "unitquantreg")
sim_bounded_curr <- sim_bounded[sim_bounded$family == "uweibull", ]

# Fitting using the analytical gradient
fit_gradient <- unitquantreg(formula = y1 ~ x,
                             data = sim_bounded_curr, tau = 0.5,
                             family = "uweibull",
                             control = unitquantreg.control(gradient = TRUE,
                                                            trace = 1))

# Fitting without using the analytical gradient
fit_nogradient <- unitquantreg(formula = y1 ~ x,
                             data = sim_bounded_curr, tau = 0.5,
                             family = "uweibull",
                             control = unitquantreg.control(gradient = FALSE,
                                                            trace = 1))
# Compare estimated coefficients
cbind(gradient = coef(fit_gradient), no_gradient = coef(fit_nogradient))

}
\references{
Nash, J. C. and Varadhan, R. (2011). Unifying Optimization Algorithms to Aid Software System Users: optimx for R., \emph{Journal of Statistical Software}, \bold{43}(9), 1--14.
}
\seealso{
\code{\link[optimx]{optimx}} for more details about control
parameters and \code{\link{unitquantreg.fit}} the fitting
procedure used by \code{\link{unitquantreg}}.
}
\author{
André F. B. Menezes
}
