% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mupdog.R
\name{summary.mupdog}
\alias{summary.mupdog}
\title{Provides some summaries from the output of \code{\link{mupdog}}.}
\usage{
\method{summary}{mupdog}(object, ...)
}
\arguments{
\item{object}{A mupdog object.}

\item{...}{Not used.}
}
\value{
A list with the following elements:
\itemize{
\item \code{freq} A matrix with the frequency of the dosages (rows) for each SNP (columns).
\item \code{mean_dosage} The posterior mean dosage of an individual (rows) for each SNP (columns).
}
}
\description{
Returns mean-dosage for each individual at each SNP and the SNP-specific distribution of MAP dosages.
The mean-dosage in particular might be of interest for downstream analyses.
}
\examples{
data(mupout)
msum <- summary(mupout)
msum$freq[, 1:5]
boxplot(msum$mean_dosage ~ mupout$map_dosage,
        xlab = "MAP Dosage", ylab = "Mean Dosage")

}
\author{
David Gerard
}
